package com.agilex.healthcare.veteranappointment.clientapi;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;

public class PatientResourceClient {
	private static org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PatientResourceClient.class);
	private JerseyClientHandle jerseyClientHandle = null;

	public PatientResourceClient(JerseyClientHandle jerseyClientHandle) {
		log.debug("initializing patient resource client");
		this.jerseyClientHandle = jerseyClientHandle;
	}

	public Patients patientSearch(Patient prototype) {
		Patients patients = null;
		if (prototype != null) {
			javax.ws.rs.client.WebTarget resourceHandle = jerseyClientHandle.resource().path("patients");
			resourceHandle = addPatientSearchQueryParams(resourceHandle, prototype);
			log.info("get uri " + resourceHandle.getUri().toString());
			patients = resourceHandle.request().get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patients patientSearch(String searchString) {
		Patients patients = null;
		if (NullChecker.isNotNullish(searchString)) {
			javax.ws.rs.client.WebTarget resourceHandle = jerseyClientHandle.resource().path("patients");
			resourceHandle = addPatientSearchQueryParam(resourceHandle, "searchstring", searchString);
			log.info("get uri " + resourceHandle.getUri().toString());
			patients = resourceHandle.request().get(Patients.class);
		} else {
			patients = new Patients();
		}

		return patients;
	}

	public Patient getPatient(URI uri) {
		javax.ws.rs.client.WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		return resourceHandle.request().get(Patient.class);
	}

	public Patient getPatient(Patient patient) {
		return getPatient(patient.getSelfUri());
	}

	public PatientDemographics getDemographics(URI uri) {
		javax.ws.rs.client.WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		return resourceHandle.request().get(PatientDemographics.class);
	}

	public PatientDemographics getDemographics(Patient patient) {
		return getDemographics(patient.getDemographicsUri());
	}

	private WebTarget addPatientSearchQueryParams(WebTarget resource, Patient prototype) {
		resource = addPatientSearchQueryParam(resource, "lastname", prototype.getLastName());
		resource = addPatientSearchQueryParam(resource, "firstname", prototype.getFirstName());
		resource = addPatientSearchQueryParam(resource, "patientid", prototype.getId());
		resource = addPatientSearchQueryParam(resource, "ssn", prototype.getSsn());
		return resource;
	}

	private WebTarget addPatientSearchQueryParam(WebTarget resource, String queryParamKey, String queryParamValue) {
		if (NullChecker.isNotNullish(queryParamValue)) {
			resource = resource.queryParam(queryParamKey, queryParamValue);
		}
		return resource;
	}

	public InputStream getPatientImage(Patient patient) {
		return getPatientImage(patient.getPatientImageUri());
	}

	public InputStream getPatientImage(URI uri) {
		javax.ws.rs.client.WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		Response response = resourceHandle.request().get();
		InputStream image = null;
		if (response.getStatus() == 200) {
			image = (InputStream)response.getEntity();
		}
		return image;
	}

	public Problems getPatientActiveProblems(Patient patient) {
		return getPatientActiveProblems(patient.getProblemsUri());
	}

	public Problems getPatientActiveProblems(URI uri) {
		WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		Problems problems = resourceHandle.request().get(Problems.class);
		return problems;
	}

	/*public Documents getPatientDocuments(Patient patient) {
		return getPatientDocuments(patient.getDocumentsUri());
	}*/

	public Documents getPatientDocuments(URI uri) {
		WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		Documents documents = resourceHandle.request().get(Documents.class);
		return documents;
	}

	public Allergies getPatientAllergies(Patient patient) {
		return getPatientAllergies(patient.getAllergiesUri());
	}

	public Allergies getPatientAllergies(URI uri) {
		WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		Allergies allergies = resourceHandle.request().get(Allergies.class);
		return allergies;
	}

	public LabTestGroups getPatientLabTestGroups(URI uri) {
		WebTarget resourceHandle = jerseyClientHandle.resource(uri);
		log.info("get uri " + resourceHandle.getUri().toString());
		LabTestGroups labTestGroups = resourceHandle.request().get(LabTestGroups.class);
		return labTestGroups;
	}

	
}
